/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef _mx_arch_h_
#define _mx_arch_h_

#include <ndis.h>
#include <stdarg.h>
#include <stdio.h>

#undef SLIST_ENTRY
#include "bsd/queue.h"
#include "mx_auto_config.h"
#include "mx_int.h"
#include "mx_io_impl.h"
#include "mx_io.h"
#include "mx_io_impl.h"
#include "mcp_config.h"
#include "mcp_global.h"
#include "mx_ntddk.h"
#include "myriexpress.h"

#define MX_PRINT(s) DbgPrint s
#define MX_WARN(s) do {  \
  DbgPrint("mx WARN: "); \
  DbgPrint s;            \
} while (0)

#define MX_INFO(s) do {  \
  DbgPrint("mx INFO: "); \
  DbgPrint s; \
} while (0)

#include "mx_debug.h"
#include "mx_pci.h"

#define MX_HAS_MAP_PCI_SPACE 1
#define MX_HAS_PCIE_LINK_RESET 1

enum MX_PNP_STATE
{
  MX_PNP_STATE_ADDED = 0,
  MX_PNP_STATE_STARTED,
  MX_PNP_STATE_QUERY_STOPPED,
  MX_PNP_STATE_STOPPED,
  MX_PNP_STATE_QUERY_REMOVED,
  MX_PNP_STATE_REMOVED,
  MX_PNP_STATE_SUPRISE_REMOVED
};

typedef struct mx_spinlock
{
  KSPIN_LOCK spin_lock;
  KIRQL old_irql;
} mx_spinlock_t;

typedef void (ether_tx_done_t)(struct mx_instance_state *, uint32_t);
typedef void (ether_rx_done_t)(struct mx_instance_state *, int, int, int, int);
typedef int (ether_open_common_t)(struct mx_instance_state *, int, int, int);
typedef int (ether_start_common_t)(struct mx_instance_state *, int, int, int);
typedef void (ether_close_common_t)(struct mx_instance_state *);
typedef int (lanai_command_t)(struct mx_instance_state *, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t *, struct mx_sync *);
typedef void (ether_link_change_notify_t)(struct mx_instance_state *);

typedef struct mx_arch_instance_info
{
  PDEVICE_OBJECT dev_obj;

  PHYSICAL_ADDRESS iomem_base;
  PHYSICAL_ADDRESS special_base;
  unsigned int special_span;
  KIRQL level;
  ULONG vector;
  KAFFINITY affinity;
  int intr_ready;
  PKINTERRUPT interrupt;
  mx_spinlock_t intr_lock;
  int intr_pending;

  PDMA_ADAPTER dma_adapter;
  ULONG map_reg_count;
  
  int unit;
  PKTHREAD mapper_thread;

  PDEVICE_OBJECT named_dev_obj;

  BUS_INTERFACE_STANDARD bus_interface;
  
  NDIS_HANDLE miniportAdapterHandle;
  NDIS_MINIPORT_INTERRUPT miniport_interrupt;
  BOOLEAN kwindow_timer_cancel;
  NDIS_EVENT kwindow_timer_event;
  NDIS_TIMER kwindow_timer;
  struct mx_adapter *adapter;
} mx_arch_instance_info_t;

struct mmapmd_entry
{
  SLIST_ENTRY(mmapmd_entry) entries;
  void *uva;
  PMDL mdl;
};

SLIST_HEAD(mmapmd_head, mmapmd_entry);

typedef struct mx_arch_endpt_info
{
  struct mmapmd_head mmapmd;
  int endpoint; /* TODO: Is this necessary? mx_endpt_state_t has endpt. */
} mx_arch_endpt_info_t;

typedef struct mx_sync
{
  FAST_MUTEX mutex;
#if 0
  KEVENT sleep_event;
#else
  KSEMAPHORE sem;
#endif
} mx_sync_t;

#define mx_alloc_copyblock mx_common_alloc_copyblock
#define mx_free_copyblock mx_common_free_copyblock

int mx_arch_copyin(mx_uaddr_t what, void *where, size_t ammount);
int mx_arch_copyout(void *what, mx_uaddr_t where, size_t ammount);

void mx_spin(uint32_t);

#ifndef MIN
#define MIN(a,b) (((a)<(b))?(a):(b))
#endif

#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif

#define bzero(ptr, len) RtlZeroMemory(ptr, len)
#define bcopy(a, b, len) RtlCopyMemory(b, a, len)

/* atomic types and operations */
#define mx_atomic_t LONG
#define mx_atomic_add(value, ptr) InterlockedExchangeAdd(ptr, value)
#define mx_atomic_subtract(value, ptr) InterlockedExchangeAdd(ptr, -value)
#define mx_atomic_read(ptr) InterlockedExchangeAdd(ptr, 0)
#define mx_atomic_set(ptr, value) InterlockedExchange(ptr, value)

/* spinlocks */
#define mx_spin_lock(lock) KeAcquireSpinLock(&(lock)->spin_lock, &(lock)->old_irql)
#define mx_spin_unlock(lock) KeReleaseSpinLock(&(lock)->spin_lock, (lock)->old_irql)
#define mx_spin_lock_irqsave(lock, flags) KeAcquireSpinLock(&(lock)->spin_lock, &(lock)->old_irql)
#define mx_spin_unlock_irqrestore(lock, flags) KeReleaseSpinLock(&(lock)->spin_lock, (lock)->old_irql)
#define mx_spin_lock_destroy(lock)

/* FIXME */
#define mx_reserve_page(x)
#define mx_unreserve_page(x)

#define snprintf _snprintf
#define vsnprintf _vsnprintf
#define offsetof(s,m)(size_t)((uintptr_t)&(((s*)0)->m))

#define mx_get_memory_context() 0

#endif /* _mx_arch_h_ */
